/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.parser.CECBit;
import com.quantumdata.busmon.parser.CECByte;
import com.quantumdata.busmon.parser.CECMessage;
import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.TypeConverter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CECDataBlock
extends DataBlock {
    protected long startstamp;
    protected long timestamp;
    protected int sourceID;
    protected CECMessage message;
    protected Vector<CECBit> rawMessage;
    protected Integer[] rawPacket;
    protected CECBit eventBit;
    protected Hashtable<String, String> faultyReasons;
    protected static CECDataBlock lastBlock = null;

    @Override
    public boolean isError() {
        return this.isBad();
    }

    public CECDataBlock(Integer[] integerArray) {
        this.sourceID = integerArray[7];
        long l = TypeConverter.composeLong(integerArray, 8);
        long l2 = TypeConverter.composeLong(integerArray, 12);
        this.eventBit = new CECBit(this.sourceID, l, l2);
        this.message = null;
        this.rawMessage = CECDataBlock.getWorkingMessage();
        this.faultyReasons = CECDataBlock.getWhyLastBad();
        this.rawPacket = (Integer[])integerArray.clone();
        if (this.eventBit.isStart()) {
            if (lastBlock != null) {
                CECDataBlock.lastBlock.message = new CECMessage(CECDataBlock.lastBlock.rawMessage);
                CECDataBlock.lastBlock.startstamp = CECDataBlock.lastBlock.timestamp;
            }
            this.rawMessage.clear();
        }
        this.rawMessage.add(this.eventBit);
        if (this.eventBit.containsIdle() && this.rawMessage.size() != 0) {
            this.message = new CECMessage(this.rawMessage);
            this.startstamp = l;
            lastBlock = null;
        } else {
            lastBlock = this;
        }
    }

    @Override
    public int getSourceID() {
        return this.sourceID;
    }

    @Override
    public long getTimestamp() {
        return this.startstamp;
    }

    public void makeDummyBlock() {
    }

    public boolean isBad() {
        return this.whyBad().size() != 0;
    }

    public String getErrorDetails() {
        String string = new String();
        Iterator<String> iterator = this.whyBad().values().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                string = string + iterator.next();
            }
        }
        return string;
    }

    public Hashtable<String, String> whyBad() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(this.faultyReasons);
        if (this.message != null) {
            hashtable.putAll(this.message.whyBad());
        }
        return hashtable;
    }

    @Override
    public String getType() {
        return "CEC";
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        if (MainAppFrame.togglePedanticAction.isTrue()) {
            stringBuffer.append(String.format("%s %s %s %s %s %s /// ", this.eventBit.isInvalid() ? "INVAL" : "Valid", this.eventBit.isStart() ? "Start" : "-----", this.eventBit.isErrorSignal() ? "Error" : "-----", this.eventBit.containsIdle() ? " IDLE" : "-----", this.eventBit.isData() ? " Data" : "-----", this.eventBit.value() ? "1" : "0"));
        }
        stringBuffer.append("\n");
        if (this.message != null) {
            stringBuffer.append(this.message.getExplanation());
        } else if (this.rawMessage != null) {
            stringBuffer.append("Incomplete Message");
        } else if (this.isBad()) {
            stringBuffer.append("Bad Message");
        } else if (!MainAppFrame.togglePedanticAction.isTrue()) {
            stringBuffer.append("Empty");
        }
        return stringBuffer.toString();
    }

    public CECMessage getMessage() {
        return this.message;
    }

    public Vector<CECByte> getRawMessage() {
        if (this.message != null) {
            return this.message.getData();
        }
        return null;
    }

    @Override
    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Timing Information\n");
        stringBuffer.append("------------------\n");
        stringBuffer.append("     Time since last reset: ");
        stringBuffer.append(TypeConverter.getTimestampString(this.startstamp * 100L));
        stringBuffer.append("\n\n");
        if (this.isBad()) {
            stringBuffer.append("Error Information\n");
            stringBuffer.append("-----------------\n");
            stringBuffer.append(this.getErrorDetails());
            stringBuffer.append("\n");
        }
        if (this.message != null) {
            stringBuffer.append("CEC Payload\n");
            stringBuffer.append("-----------\n");
            stringBuffer.append(this.message.getDetails());
            stringBuffer.append("\n");
        }
        if (MainAppFrame.togglePedanticAction.isTrue()) {
            if (this.message == null) {
                stringBuffer.append("\nThis datablock does not contain a completed message.\n");
                stringBuffer.append("\nThe raw data for this block is as follows:\n");
            }
            stringBuffer.append(String.format("\nThis data block contains the following CEC Bit:\n      Raw data:\n%s\n    Monitor ID = %d\n     Timestamp = %s\n Hi/Low Timing = %s\n     Bit Flags = %s %s %s %s %s %s\n", this.getHex(this.rawPacket), this.eventBit.getMonitorID(), TypeConverter.getTimestampString(this.eventBit.getTimestamp()), this.eventBit.getPeriodString(), this.eventBit.isInvalid() ? "INVAL" : "Valid", this.eventBit.isStart() ? "Start" : "-----", this.eventBit.isErrorSignal() ? "Error" : "-----", this.eventBit.containsIdle() ? " IDLE" : "-----", this.eventBit.isData() ? " Data" : "-----", this.eventBit.value() ? "1" : "0"));
            stringBuffer.append("\n");
        }
        if (this.isBad()) {
            stringBuffer.append("\n------------------\n");
            stringBuffer.append(this.getErrorDetails());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void resetParser() {
        lastBlock = null;
    }

    public static Vector<CECBit> getWorkingMessage() {
        if (lastBlock != null) {
            return new Vector<CECBit>(CECDataBlock.lastBlock.rawMessage);
        }
        return new Vector<CECBit>();
    }

    public static boolean lastWasBad() {
        if (lastBlock != null) {
            return lastBlock.isBad();
        }
        return false;
    }

    public static Hashtable<String, String> getWhyLastBad() {
        if (CECDataBlock.lastWasBad()) {
            return new Hashtable<String, String>(lastBlock.whyBad());
        }
        return new Hashtable<String, String>();
    }

    @Override
    public String getDirection() {
        if (this.message != null) {
            return this.message.getDirection();
        }
        return "";
    }

    @Override
    public short getSource() {
        return 1;
    }

    @Override
    public String getSourceName() {
        return "CEC";
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    @Override
    public boolean isI2C() {
        return false;
    }

    @Override
    public boolean isCEC() {
        return true;
    }

    @Override
    public boolean isHDCP() {
        return false;
    }

    @Override
    public boolean isDDCCI() {
        return false;
    }

    @Override
    public boolean isEDID() {
        return false;
    }

    @Override
    public boolean isLT() {
        return false;
    }
}

